/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import io.github.fabricators_of_create.porting_lib.entity.events.PlayerInteractionEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.ShieldBlockEvent;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2694;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class InteractionHandler {
    public static final class_1304[] HAND_SLOTS = new class_1304[]{class_1304.field_6173, class_1304.field_6171};
    private static final TinkerDataCapability.ComputableDataKey<LastTick> LAST_TICK = TConstruct.createKey("last_tick", LastTick::new);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static class_1269 beforeEntityInteract(class_1657 player, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hitResult) {
        class_1799 stack = player.method_5998(hand);
        InteractionSource source = InteractionSource.RIGHT_CLICK;
        if (!stack.method_31573(TinkerTags.Items.HELD)) {
            if (!stack.method_7960()) return class_1269.field_5811;
            stack = player.method_6118(class_1304.field_6174);
            if (!stack.method_31573(TinkerTags.Items.INTERACTABLE_ARMOR)) return class_1269.field_5811;
            source = InteractionSource.ARMOR;
        }
        if (player.method_7357().method_7904(stack.method_7909())) return class_1269.field_5811;
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            class_1269 result = entry.getHook(TinkerHooks.ENTITY_INTERACT).beforeEntityUse(tool, entry, player, target, hand, source);
            if (!result.method_23665()) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    static class_1269 afterEntityInteract(class_1657 player, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hitResult) {
        class_1799 chestplate;
        if (player.method_5998(hand).method_7960() && !player.method_7325() && (chestplate = player.method_6118(class_1304.field_6174)).method_31573(TinkerTags.Items.INTERACTABLE_ARMOR) && !player.method_7357().method_7904(chestplate.method_7909())) {
            ToolStack tool = ToolStack.from(chestplate);
            class_1269 result = target.method_5688(player, hand);
            if (result.method_23665()) {
                return class_1269.field_5811;
            }
            if (target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                for (ModifierEntry entry : tool.getModifierList()) {
                    result = entry.getHook(TinkerHooks.ENTITY_INTERACT).afterEntityUse(tool, entry, player, livingTarget, hand, InteractionSource.ARMOR);
                    if (!result.method_23665()) continue;
                    return result;
                }
            }
            result = InteractionHandler.onChestplateUse(player, chestplate, hand);
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onBlockUse(class_1838 context, IToolStackView tool, class_1799 stack, Function<ModifierEntry, class_1269> callback) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2694 info = new class_2694((class_4538)world, context.method_8037(), false);
        if (player != null && !player.method_31549().field_7476 && !stack.method_7944((class_2378)class_7923.field_41175, info)) {
            return class_1269.field_5811;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            class_1269 result = callback.apply(entry);
            if (!result.method_23665()) continue;
            if (player != null) {
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            }
            return result;
        }
        return class_1269.field_5811;
    }

    static class_1269 chestplateInteractWithBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 trace) {
        class_1799 chestplate;
        if (player.method_5998(hand).method_7960() && !player.method_7325() && (chestplate = player.method_6118(class_1304.field_6174)).method_31573(TinkerTags.Items.INTERACTABLE_ARMOR) && !player.method_7357().method_7904(chestplate.method_7909())) {
            class_1269 result;
            class_1838 context = new class_1838(player, hand, trace);
            ToolStack tool = ToolStack.from(chestplate);
            class_1269 result2 = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getHook(TinkerHooks.BLOCK_INTERACT).beforeBlockUse(tool, (ModifierEntry)entry, context, InteractionSource.ARMOR));
            if (result2.method_23665()) {
                return result2;
            }
            class_2338 pos = trace.method_17777();
            if (!player.method_21823() && (result = player.method_37908().method_8320(pos).method_26174(player.method_37908(), player, hand, trace)).method_23665()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, class_1799.field_8037);
                }
                return result;
            }
            if (!player.method_7357().method_7904(chestplate.method_7909()) && (result = InteractionHandler.onBlockUse(context, tool, chestplate, entry -> entry.getHook(TinkerHooks.BLOCK_INTERACT).afterBlockUse(tool, (ModifierEntry)entry, context, InteractionSource.ARMOR))).method_23665()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, class_1799.field_8037);
                }
                return result;
            }
            return InteractionHandler.onChestplateUse(player, chestplate, hand);
        }
        return class_1269.field_5811;
    }

    public static class_1269 onChestplateUse(class_1657 player, class_1799 chestplate, class_1268 hand) {
        if (player.method_7357().method_7904(chestplate.method_7909())) {
            return class_1269.field_5811;
        }
        ToolStack tool = ToolStack.from(chestplate);
        for (ModifierEntry entry : tool.getModifierList()) {
            class_1269 result = entry.getHook(TinkerHooks.CHARGEABLE_INTERACT).onToolUse(tool, entry, player, hand, InteractionSource.ARMOR);
            if (!result.method_23665()) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    static class_1269 onChestplateAttack(class_1657 attacker, class_1937 world, class_1268 hand, class_1297 target, @Nullable class_3966 hitResult) {
        ToolStack tool;
        class_1799 chestplate;
        if (attacker.method_6047().method_7960() && (chestplate = attacker.method_6118(class_1304.field_6174)).method_31573(TinkerTags.Items.UNARMED) && !(tool = ToolStack.from(chestplate)).isBroken()) {
            ToolAttackUtil.attackEntity(tool, (class_1309)attacker, class_1268.field_5808, target, ToolAttackUtil.getCooldownFunction(attacker, class_1268.field_5808), false, class_1304.field_6174);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static boolean startArmorInteract(class_1657 player, class_1304 slotType, TooltipKey modifierKey) {
        class_1799 helmet;
        if (!player.method_7325() && (helmet = player.method_6118(slotType)).method_31573(TinkerTags.Items.ARMOR)) {
            ToolStack tool = ToolStack.from(helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                if (entry.getHook(TinkerHooks.ARMOR_INTERACT).startInteract(tool, entry, player, slotType, modifierKey)) break;
            }
            return true;
        }
        return false;
    }

    public static boolean stopArmorInteract(class_1657 player, class_1304 slotType) {
        class_1799 helmet;
        if (!player.method_7325() && (helmet = player.method_6118(slotType)).method_31573(TinkerTags.Items.ARMOR)) {
            ToolStack tool = ToolStack.from(helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.ARMOR_INTERACT).stopInteract(tool, entry, player, slotType);
            }
            return true;
        }
        return false;
    }

    private static class_1269 onLeftClickInteraction(IToolStackView tool, class_1657 player, class_1268 hand) {
        for (ModifierEntry entry : tool.getModifierList()) {
            class_1269 result = entry.getHook(TinkerHooks.CHARGEABLE_INTERACT).onToolUse(tool, entry, player, hand, InteractionSource.LEFT_CLICK);
            if (!result.method_23665()) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onLeftClickInteraction(class_1657 player, class_1799 held, class_1268 hand) {
        if (player.method_7357().method_7904(held.method_7909())) {
            return class_1269.field_5811;
        }
        return InteractionHandler.onLeftClickInteraction(ToolStack.from(held), player, hand);
    }

    private static void setLeftClickEventResult(PlayerInteractionEvents event, class_1269 result) {
        if (result.method_23665()) {
            if (result == class_1269.field_5812) {
                event.getPlayer().method_6104(event.getHand());
            }
            event.setCancellationResult(result);
            if (event.getPlayer().method_31549().field_7477) {
                event.setCanceled(true);
            }
        }
    }

    static void leftClickBlock(PlayerInteractionEvents.LeftClickBlock event) {
        class_1269 result;
        class_1657 player = event.getPlayer();
        if (TinkerDataCapability.CAPABILITY.maybeGet((Object)player).filter(data -> ((LastTick)data.computeIfAbsent(LAST_TICK)).update(player)).isEmpty()) {
            return;
        }
        class_1799 stack = event.getItemStack();
        if (!stack.method_31573(TinkerTags.Items.INTERACTABLE_LEFT) || player.method_7357().method_7904(stack.method_7909())) {
            return;
        }
        class_1268 hand = event.getHand();
        class_2338 pos = event.getPos();
        class_2350 direction = event.getFace();
        if (direction == null) {
            direction = player.method_5735().method_10153();
        }
        class_1838 context = new class_1838(player, hand, new class_3965(Util.toHitVec(pos, direction), direction, pos, false));
        ToolStack tool = ToolStack.from(stack);
        List<ModifierEntry> modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            result = entry.getHook(TinkerHooks.BLOCK_INTERACT).beforeBlockUse(tool, entry, context, InteractionSource.LEFT_CLICK);
            if (!result.method_23665()) continue;
            InteractionHandler.setLeftClickEventResult((PlayerInteractionEvents)event, result);
            event.setCanceled(true);
            return;
        }
        for (ModifierEntry entry : modifiers) {
            result = entry.getHook(TinkerHooks.BLOCK_INTERACT).afterBlockUse(tool, entry, context, InteractionSource.LEFT_CLICK);
            if (!result.method_23665()) continue;
            InteractionHandler.setLeftClickEventResult((PlayerInteractionEvents)event, result);
            event.setCanceled(true);
            return;
        }
        class_1269 result2 = InteractionHandler.onLeftClickInteraction(tool, player, hand);
        if (result2.method_23665()) {
            InteractionHandler.setLeftClickEventResult((PlayerInteractionEvents)event, result2);
        }
    }

    public static void init() {
        UseEntityCallback.EVENT.register(InteractionHandler::beforeEntityInteract);
        UseEntityCallback.EVENT.register(TConstruct.getResource("event_phase"), InteractionHandler::afterEntityInteract);
        UseEntityCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, TConstruct.getResource("event_phase"));
        UseBlockCallback.EVENT.register(InteractionHandler::chestplateInteractWithBlock);
        AttackEntityCallback.EVENT.register(InteractionHandler::onChestplateAttack);
        PlayerInteractionEvents.LEFT_CLICK_BLOCK.register(InteractionHandler::leftClickBlock);
        ShieldBlockEvent.EVENT.register(InteractionHandler::onBlock);
    }

    public static boolean canBlock(class_1309 holder, @Nullable class_243 sourcePosition, IToolStackView tool) {
        if (sourcePosition == null) {
            return false;
        }
        float blockAngle = ConditionalStatModifierHook.getModifiedStat(tool, holder, ToolStats.BLOCK_ANGLE) / 2.0f;
        class_243 viewVector = holder.method_5828(1.0f);
        class_243 entityPosition = holder.method_19538();
        class_243 direction = new class_243(entityPosition.field_1352 - sourcePosition.field_1352, 0.0, entityPosition.field_1350 - sourcePosition.field_1350);
        double length = viewVector.method_1033() * direction.method_1033();
        if (length < 1.0E-4) {
            return false;
        }
        double angle = Math.abs(180.0 - Math.acos(direction.method_1026(viewVector) / length) * 57.2957763671875);
        return (double)blockAngle >= angle;
    }

    static void onBlock(ShieldBlockEvent event) {
        class_1309 entity = event.getEntity();
        class_1799 activeStack = entity.method_6030();
        if (!activeStack.method_7960() && activeStack.method_31573(TinkerTags.Items.MODIFIABLE)) {
            ToolStack tool = ToolStack.from(activeStack);
            if (!tool.isBroken() && InteractionHandler.canBlock(event.getEntity(), event.getDamageSource().method_5510(), tool)) {
                event.setBlockedDamage(Math.min(event.getBlockedDamage(), tool.getStats().get(ToolStats.BLOCK_AMOUNT).floatValue()));
            } else {
                event.setCanceled(true);
            }
        }
    }

    private static class LastTick {
        private long lastTick = 0L;

        private LastTick() {
        }

        private boolean update(class_1657 player) {
            if ((long)player.field_6012 >= this.lastTick + 4L) {
                this.lastTick = player.field_6012;
                return true;
            }
            return false;
        }
    }
}

